<?php
// Arquivo para verificar se as modificações estão funcionando
echo "<h1>Verificação do Sistema</h1>";

// 1. Verificar se o arquivo db.php existe
if (file_exists('db.php')) {
    echo "<p style='color:green;'>✅ Arquivo db.php encontrado</p>";
    
    // 2. Testar conexão com banco
    try {
        require 'db.php';
        echo "<p style='color:green;'>✅ Conexão com banco estabelecida</p>";
        
        // 3. Verificar se a tabela transacoes existe
        $result = $conexao->query("SHOW TABLES LIKE 'transacoes'");
        if ($result->num_rows > 0) {
            echo "<p style='color:green;'>✅ Tabela 'transacoes' encontrada</p>";
            
            // 4. Verificar se o campo comprovante_pagamento existe
            $result = $conexao->query("SHOW COLUMNS FROM transacoes LIKE 'comprovante_pagamento'");
            if ($result->num_rows > 0) {
                echo "<p style='color:green;'>✅ Campo 'comprovante_pagamento' encontrado</p>";
            } else {
                echo "<p style='color:red;'>❌ Campo 'comprovante_pagamento' NÃO encontrado</p>";
                echo "<p><strong>Execute este SQL:</strong></p>";
                echo "<code>ALTER TABLE transacoes ADD COLUMN comprovante_pagamento VARCHAR(255) NULL AFTER forma_pagamento;</code>";
            }
            
            // 5. Verificar se a tabela contas_pagar existe
            $result = $conexao->query("SHOW TABLES LIKE 'contas_pagar'");
            if ($result->num_rows > 0) {
                echo "<p style='color:green;'>✅ Tabela 'contas_pagar' encontrada</p>";
            } else {
                echo "<p style='color:red;'>❌ Tabela 'contas_pagar' NÃO encontrada</p>";
                echo "<p><strong>Execute o script SQL completo para criar a tabela</strong></p>";
            }
            
        } else {
            echo "<p style='color:red;'>❌ Tabela 'transacoes' NÃO encontrada</p>";
        }
        
        $conexao->close();
        
    } catch (Exception $e) {
        echo "<p style='color:red;'>❌ Erro na conexão: " . $e->getMessage() . "</p>";
    }
    
} else {
    echo "<p style='color:red;'>❌ Arquivo db.php NÃO encontrado</p>";
}

// 6. Verificar versão do PHP
echo "<p><strong>Versão do PHP:</strong> " . phpversion() . "</p>";

// 7. Verificar se a pasta uploads existe
if (is_dir('uploads/comprovantes/')) {
    echo "<p style='color:green;'>✅ Pasta uploads/comprovantes/ encontrada</p>";
} else {
    echo "<p style='color:orange;'>⚠️ Pasta uploads/comprovantes/ NÃO encontrada</p>";
    echo "<p>Crie a pasta: <code>mkdir -p uploads/comprovantes</code></p>";
}

echo "<hr>";
echo "<p><a href='index.php'>← Voltar para o Dashboard</a></p>";
?>
