<?php
require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../helpers/AuthHelper.php';

AuthHelper::check();

$pageTitle = "Recursos Humanos";
$nome = $_SESSION['nome'] ?? 'Usuário';
?>

<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $pageTitle ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        :root {
            --primary-color: #0B1F3A;
            --secondary-color: #102B54;
            --accent-color: #3B82F6;
        }
        
        .navbar-custom {
            background: linear-gradient(135deg, var(--primary-color), var(--secondary-color));
        }
        
        body {
            font-family: 'Inter', sans-serif;
            background-color: #f8fafc;
            color: #334155;
            line-height: 1.6;
        }
        
        .card-module {
            transition: transform 0.2s, box-shadow 0.2s;
            border: none;
            border-radius: 12px;
            overflow: hidden;
        }
        
        .card-module:hover {
            transform: translateY(-4px);
            box-shadow: 0 10px 25px rgba(0,0,0,0.1);
        }
        
        .module-icon {
            width: 60px;
            height: 60px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.5rem;
            color: white;
        }
        
        .icon-employees { background: linear-gradient(135deg, #3B82F6, #1D4ED8); }
        .icon-timerecords { background: linear-gradient(135deg, #10B981, #059669); }
        .icon-payroll { background: linear-gradient(135deg, #F59E0B, #D97706); }
    </style>
</head>
<body>
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark navbar-custom">
        <div class="container-fluid">
            <span class="navbar-brand">
                <i class="bi bi-people-fill me-2"></i>
                Recursos Humanos
            </span>
            <div class="d-flex align-items-center text-white">
                <span class="me-3">Olá, <?= htmlspecialchars($nome) ?></span>
                <a href="<?= BASE_URL ?>/src/views/dashboard/" class="btn btn-outline-light btn-sm">
                    <i class="bi bi-house-fill me-1"></i>Painel
                </a>
            </div>
        </div>
    </nav>

    <div class="container-fluid py-4">
        <div class="container">
            <!-- Cabeçalho da página -->
            <div class="d-flex justify-content-between align-items-center mb-4">
                <div>
                    <h1 class="mb-1" style="color: #2c3e50; font-weight: 600;">
                        <i class="bi bi-people-fill me-2"></i>Recursos Humanos
                    </h1>
                    <p class="text-muted mb-0">Gerencie colaboradores, controle de ponto e folha de pagamento</p>
                </div>
            </div>

            <!-- Cards dos Módulos -->
            <div class="row g-4">
                <!-- Colaboradores -->
                <div class="col-md-6 col-lg-4">
                    <div class="card card-module h-100">
                        <div class="card-body p-4">
                            <div class="d-flex align-items-center mb-3">
                                <div class="module-icon icon-employees me-3">
                                    <i class="bi bi-person-badge"></i>
                                </div>
                                <h5 class="card-title mb-0">Colaboradores</h5>
                            </div>
                            <p class="card-text text-muted mb-3">Cadastre e gerencie informações dos colaboradores</p>
                            <a href="<?= BASE_URL ?>/src/views/employees/" class="btn btn-primary">
                                <i class="bi bi-arrow-right me-1"></i>Acessar
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Controle de Ponto -->
                <div class="col-md-6 col-lg-4">
                    <div class="card card-module h-100">
                        <div class="card-body p-4">
                            <div class="d-flex align-items-center mb-3">
                                <div class="module-icon icon-timerecords me-3">
                                    <i class="bi bi-clock"></i>
                                </div>
                                <h5 class="card-title mb-0">Controle de Ponto</h5>
                            </div>
                            <p class="card-text text-muted mb-3">Registre e monitore horários de trabalho</p>
                            <a href="<?= BASE_URL ?>/src/views/time_records/" class="btn btn-success">
                                <i class="bi bi-arrow-right me-1"></i>Acessar
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Folha de Pagamento -->
                <div class="col-md-6 col-lg-4">
                    <div class="card card-module h-100">
                        <div class="card-body p-4">
                            <div class="d-flex align-items-center mb-3">
                                <div class="module-icon icon-payroll me-3">
                                    <i class="bi bi-currency-dollar"></i>
                                </div>
                                <h5 class="card-title mb-0">Folha de Pagamento</h5>
                            </div>
                            <p class="card-text text-muted mb-3">Gerencie salários e benefícios dos colaboradores</p>
                            <a href="<?= BASE_URL ?>/src/views/payrolls/" class="btn btn-warning">
                                <i class="bi bi-arrow-right me-1"></i>Acessar
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>