<?php
require_once __DIR__ . '/../../helpers/PermissionHelper.php';
?>

<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h3 class="card-title">
                        <i class="fas fa-shield-alt"></i>
                        Gerenciar Níveis de Acesso
                    </h3>
                    <a href="<?= BASE_URL ?>/paineladmin/usuarios" class="btn btn-secondary">
                        <i class="fas fa-users"></i>
                        Voltar para Usuários
                    </a>
                </div>
                <div class="card-body">
                    <?php if (isset($_SESSION['success_message'])): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <?= $_SESSION['success_message'] ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                        <?php unset($_SESSION['success_message']); ?>
                    <?php endif; ?>

                    <?php if (isset($_SESSION['error_message'])): ?>
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            <?= $_SESSION['error_message'] ?>
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                        <?php unset($_SESSION['error_message']); ?>
                    <?php endif; ?>

                    <div class="row">
                        <?php foreach ($niveisAcesso as $nivel => $descricao): ?>
                            <div class="col-md-6 col-lg-4 mb-4">
                                <div class="card h-100 border-left-primary">
                                    <div class="card-body">
                                        <div class="d-flex justify-content-between align-items-center mb-3">
                                            <h5 class="card-title text-primary mb-0">
                                                <?= PermissionHelper::getNomeNivelAcesso($nivel) ?>
                                            </h5>
                                            <span class="badge bg-info">
                                                <?= $estatisticas[$nivel] ?? 0 ?> usuários
                                            </span>
                                        </div>
                                        
                                        <p class="card-text text-muted mb-3">
                                            <?= $descricao ?>
                                        </p>

                                        <div class="permissions-list">
                                            <h6 class="text-secondary mb-2">
                                                <i class="fas fa-key"></i>
                                                Permissões:
                                            </h6>
                                            <?php
                                            $permissoes = [
                                                'Admin' => ['agenda', 'documentos', 'eleitores', 'rh', 'financeiro'],
                                                'Agenda_Financeiro_Documentos' => ['agenda', 'financeiro', 'documentos'],
                                                'Eleitor_Documentos' => ['eleitores', 'documentos'],
                                                'Documentos_Financeiro_RH' => ['documentos', 'financeiro', 'rh'],
                                                'Acesso_Total' => ['agenda', 'documentos', 'eleitores', 'rh', 'financeiro']
                                            ];
                                            
                                            $modulosNivel = $permissoes[$nivel] ?? [];
                                            ?>
                                            
                                            <div class="row">
                                                <?php foreach (['agenda', 'documentos', 'eleitores', 'rh', 'financeiro'] as $modulo): ?>
                                                    <div class="col-6 mb-1">
                                                        <small class="<?= in_array($modulo, $modulosNivel) ? 'text-success' : 'text-muted' ?>">
                                                            <i class="fas <?= in_array($modulo, $modulosNivel) ? 'fa-check' : 'fa-times' ?>"></i>
                                                            <?= ucfirst($modulo) ?>
                                                        </small>
                                                    </div>
                                                <?php endforeach; ?>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>

                    <div class="mt-4">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0">
                                    <i class="fas fa-info-circle"></i>
                                    Informações sobre Níveis de Acesso
                                </h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-6">
                                        <h6 class="text-primary">Tipos de Permissões:</h6>
                                        <ul class="list-unstyled">
                                            <li><i class="fas fa-eye text-info"></i> <strong>Visualizar:</strong> Ver dados do módulo</li>
                                            <li><i class="fas fa-plus text-success"></i> <strong>Criar:</strong> Adicionar novos registros</li>
                                            <li><i class="fas fa-edit text-warning"></i> <strong>Editar:</strong> Modificar registros existentes</li>
                                            <li><i class="fas fa-trash text-danger"></i> <strong>Excluir:</strong> Remover registros</li>
                                        </ul>
                                    </div>
                                    <div class="col-md-6">
                                        <h6 class="text-primary">Módulos do Sistema:</h6>
                                        <ul class="list-unstyled">
                                            <li><i class="fas fa-calendar text-primary"></i> <strong>Agenda:</strong> Gerenciar compromissos</li>
                                            <li><i class="fas fa-file-alt text-info"></i> <strong>Documentos:</strong> Gerenciar documentos</li>
                                            <li><i class="fas fa-users text-success"></i> <strong>Eleitores:</strong> Cadastro de eleitores</li>
                                            <li><i class="fas fa-user-tie text-warning"></i> <strong>RH:</strong> Recursos Humanos</li>
                                            <li><i class="fas fa-dollar-sign text-danger"></i> <strong>Financeiro:</strong> Gestão financeira</li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.border-left-primary {
    border-left: 4px solid #007bff !important;
}

.permissions-list {
    background-color: #f8f9fa;
    padding: 15px;
    border-radius: 8px;
    border: 1px solid #e9ecef;
}

.card {
    box-shadow: 0 0.15rem 1.75rem 0 rgba(58, 59, 69, 0.15);
    border: 1px solid #e3e6f0;
}

.card-header {
    background-color: #f8f9fa;
    border-bottom: 1px solid #e3e6f0;
}

.badge {
    font-size: 0.75rem;
}

.text-success {
    color: #28a745 !important;
}

.text-muted {
    color: #6c757d !important;
}

.fa-check {
    color: #28a745;
}

.fa-times {
    color: #dc3545;
}
</style>