<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Proteção de rota
if (empty($_SESSION['user_id'])) {
    header('Location: ' . BASE_URL . '/login.php', true, 302);
    exit;
}

// Configurações
require_once __DIR__ . '/../../config/config.php';
require_once __DIR__ . '/../../models/Eleitor.php';

// Carrega configurações
require_once __DIR__ . '/../../../src/config/config.php';
$BASE_PATH = rtrim(BASE_URL, '/');
$BASE_URL = BASE_URL;

// Buscar eleitores
$eleitorModel = new Eleitor();
$busca = $_GET['busca'] ?? '';

// Filtro por nível de acesso
$usuarioId = null;
if (isset($_SESSION['nivel_acesso']) && $_SESSION['nivel_acesso'] === 'Eleitor') {
    $usuarioId = $_SESSION['user_id'];
}

if (!empty($busca)) {
    $eleitores = $eleitorModel->search($busca, $usuarioId);
} else {
    $eleitores = $eleitorModel->getAll($usuarioId);
}

$nome = $_SESSION['nome'] ?? 'Usuário';
?>
<!DOCTYPE html>
<html lang="pt-BR">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Lista de Eleitores - Gabinete</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <style>
        :root {
            --primary-color: #88589dff;
            --secondary-color: #88589dff;
            --accent-color: #3b82f6;
            --hover-color: #2563eb;
        }

        body {
            background: var(--primary-color);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        /* Cabeçalho com cor azul personalizada */
        .navbar-custom {
            background: linear-gradient(135deg, #070849ff, #070849ff) !important;
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .content-container {
            background: white;
            border-radius: 12px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
            margin: 20px 0;
        }

        .search-container {
            background: white;
            padding: 20px;
            border-radius: 12px;
            margin-bottom: 20px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
        }

        .table {
            margin-bottom: 0;
        }

        .table th {
            background: var(--primary-color);
            color: white;
            border: none;
            font-weight: 600;
        }

        .table-hover tbody tr:hover {
            background-color: #f8f9fa;
        }

        .btn-search {
            background: #28a745;
            border: none;
            color: white;
            transition: all 0.3s ease;
        }

        .btn-search:hover {
            background: #218838;
            color: white;
            transform: translateY(-1px);
        }

        .btn-clear {
            background: #dc3545;
            border: none;
            color: white;
            transition: all 0.3s ease;
        }

        .btn-clear:hover {
            background: #c82333;
            color: white;
            transform: translateY(-1px);
        }

        .btn-add {
            background: var(--accent-color);
            border: none;
            color: white;
            transition: all 0.3s ease;
        }

        .btn-add:hover {
            background: var(--hover-color);
            color: white;
            transform: translateY(-1px);
        }

        .btn-report {
            background: #17a2b8;
            border: none;
            color: white;
            transition: all 0.3s ease;
        }

        .btn-report:hover {
            background: #138496;
            color: white;
            transform: translateY(-1px);
        }

        .btn-outline-light:hover {
            background: rgba(255, 255, 255, 0.2);
            border-color: rgba(255, 255, 255, 0.3);
            color: white;
        }

        .actions a {
            margin: 0 5px;
            color: #6c757d;
            transition: all 0.3s ease;
            padding: 5px;
            border-radius: 4px;
        }

        .actions a:hover {
            color: var(--accent-color);
            background: rgba(59, 130, 246, 0.1);
        }

        .navbar-brand {
            font-weight: 600;
            font-size: 1.25rem;
        }

        .card-stats {
            border-left: 4px solid var(--accent-color);
            transition: transform 0.3s ease;
        }

        .card-stats:hover {
            transform: translateY(-2px);
        }

        .pagination-container {
            background: white;
            padding: 20px;
            border-radius: 12px;
            margin-top: 20px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
        }
    </style>
</head>

<body>
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark navbar-custom">
        <div class="container-fluid">
            <span class="navbar-brand">
                <i class="bi bi-people-fill me-2"></i>
                Eleitores & Cadastros
            </span>
            <div class="d-flex align-items-center text-white">
                <span class="me-3">Olá, <?= htmlspecialchars($nome) ?></span>
                <a href="<?= BASE_URL ?>/src/views/dashboard/" class="btn btn-outline-light btn-sm">
                    <i class="bi bi-house-fill me-1"></i>Painel
                </a>
            </div>
        </div>
    </nav>

    <div class="container-fluid py-4">
        <div class="content-container p-4">
            <h1 class="mb-4" style="color: #2c3e50; font-weight: 600;"><i class="bi bi-people-fill me-2"></i>Lista de
                Eleitores</h1>

            <!-- Campo de Busca -->
            <div class="search-container">
                <form method="GET" class="row g-3">
                    <div class="col-md-8">
                        <input type="text" name="busca" class="form-control"
                            placeholder="Buscar por nome, telefone ou bairro..."
                            value="<?= htmlspecialchars($_GET['busca'] ?? '') ?>">
                    </div>
                    <div class="col-md-4">
                        <button type="submit" class="btn btn-search text-white me-2">
                            <i class="bi bi-search"></i> Buscar
                        </button>
                        <?php if (!empty($_GET['busca'])): ?>
                            <a href="?" class="btn btn-clear text-white">
                                <i class="bi bi-x-circle"></i> Limpar
                            </a>
                        <?php endif; ?>
                    </div>
                </form>
            </div>

            <div class="d-flex justify-content-between align-items-center mb-3">
                <div class="action-buttons">
                    <a href="<?= $BASE_URL ?>/src/views/eleitores/cadastrar.php" class="btn btn-add text-white">
                        <i class="bi bi-plus-circle"></i> Adicionar Novo Eleitor
                    </a>
                    <a href="<?= $BASE_URL ?>/src/views/relatorios" class="btn btn-report text-white">
                        <i class="bi bi-bar-chart"></i> Relatório de Eleitores
                    </a>
                    <a href="https://www.tse.jus.br/servicos-eleitorais/autoatendimento-eleitoral#/atendimento-eleitor" class="btn btn-report text-white">
                        <i class="bi bi-bar-chart"></i> Consulta TRE Eleitores
                    </a>
                </div>
                <small class="text-muted">Total: <?= count($eleitores) ?> eleitor(es)</small>
            </div>

            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            <th>Nome Completo</th>
                            <th>Telefone</th>
                            <th>Bairro</th>
                            <th width="120">Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (count($eleitores) > 0): ?>
                            <?php foreach ($eleitores as $eleitor): ?>
                                <tr>
                                    <td><?= htmlspecialchars($eleitor['nome_completo']) ?></td>
                                    <td><?= htmlspecialchars($eleitor['telefone'] ?? 'N/A') ?></td>
                                    <td><?= htmlspecialchars($eleitor['bairro'] ?? 'N/A') ?></td>
                                    <td class="actions">
                                        <a href="detalhes.php?id=<?= $eleitor['id'] ?>" title="Ver Detalhes">
                                            <i class="bi bi-eye"></i>
                                        </a>
                                        <a href="editar.php?id=<?= $eleitor['id'] ?>" title="Editar">
                                            <i class="bi bi-pencil"></i>
                                        </a>
                                        <a href="#" onclick="confirmarExclusao(<?= $eleitor['id'] ?>)" title="Excluir">
                                            <i class="bi bi-trash text-danger"></i>
                                        </a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php else: ?>
                            <tr>
                                <td colspan="4" class="text-center py-4">
                                    <?php if (!empty($_GET['busca'])): ?>
                                        <i class="bi bi-search text-muted"></i><br>
                                        Nenhum eleitor encontrado para "<?= htmlspecialchars($_GET['busca']) ?>".
                                    <?php else: ?>
                                        <i class="bi bi-people text-muted"></i><br>
                                        Nenhum eleitor cadastrado.
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function confirmarExclusao(id) {
            if (confirm('Tem certeza que deseja excluir este eleitor?')) {
                window.location.href = '<?= $BASE_URL ?>/eleitores/delete/' + id;
            }
        }
    </script>
</body>

</html>