<?php
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Proteção de rota
if (empty($_SESSION['user_id'])) {
    header('Location: ' . BASE_URL . '/login.php', true, 302);
    exit;
}

// Configurações
require_once __DIR__ . '/../../config/config.php';

// Carrega configurações
$BASE_PATH = rtrim(BASE_URL, '/');
$BASE_URL = BASE_URL;
$nome = $_SESSION['nome'] ?? 'Usuário';
$bairros = require __DIR__ . '/../../../src/config/bairros.php';
?>
<!DOCTYPE html>
<html lang="pt-BR">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Cadastrar Eleitor - Gabinete</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        :root {
            --primary-color: #88589dff;
            --secondary-color: #88589dff;
            --accent-color: #3b82f6;
            --hover-color: #2563eb;
        }

        body {
            background: var(--primary-color);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        /* Cabeçalho com cor azul personalizada */
        .navbar-custom {
            background: linear-gradient(135deg, #070849ff, #070849ff) !important;
            backdrop-filter: blur(10px);
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        }

        .content-container {
            background: white;
            border-radius: 12px;
            box-shadow: 0 2px 8px rgba(0, 0, 0, 0.05);
            margin: 20px 0;
        }
    </style>
</head>

<body>
    <!-- Navbar -->
    <nav class="navbar navbar-expand-lg navbar-dark navbar-custom">
        <div class="container-fluid">
            <span class="navbar-brand">
                <i class="bi bi-person-plus-fill me-2"></i>
                Cadastrar Eleitor
            </span>
            <div class="d-flex align-items-center text-white">
                <span class="me-3">Olá, <?= htmlspecialchars($nome) ?></span>
                <a href="<?= $BASE_URL ?>/src/views/eleitores/lista.php" class="btn btn-outline-light btn-sm me-2">
                    <i class="bi bi-arrow-left me-1"></i>Voltar
                </a>
                <a href="<?= $BASE_URL ?>/src/views/dashboard/" class="btn btn-outline-light btn-sm">
                    <i class="bi bi-house-fill me-1"></i>Painel
                </a>
            </div>
        </div>
    </nav>

    <div class="container-fluid py-4">
        <div class="content-container p-4">

            <div class="content-box">
                <h1><i class="fas fa-user-plus"></i> Cadastrar Eleitor</h1>
                <p>Preencha os dados abaixo para adicionar um novo eleitor ao sistema.</p>

                <!-- Action aponta para o Controller via Roteador -->
                <form action="<?= $BASE_URL ?>/index.php?url=eleitores/store" method="POST">

                    <h4 class="mb-3 mt-4 border-bottom pb-2 text-secondary"><i class="fas fa-id-card me-2"></i> Dados
                        Pessoais</h4>
                    <div class="row g-3">
                        <div class="col-12 col-md-8">
                            <label for="nome_completo" class="form-label fw-bold">Nome Completo:</label>
                            <input type="text" class="form-control" id="nome_completo" name="nome_completo" required>
                        </div>
                        <div class="col-12 col-md-4">
                            <label for="cpf" class="form-label fw-bold">CPF:</label>
                            <input type="text" class="form-control" id="cpf" name="cpf" placeholder="000.000.000-00">
                        </div>
                        <div class="col-12 col-md-4">
                            <label for="data_nascimento" class="form-label fw-bold">Data de Nascimento:</label>
                            <input type="date" class="form-control" id="data_nascimento" name="data_nascimento">
                        </div>
                        <div class="col-12 col-md-4">
                            <label for="telefone" class="form-label fw-bold">Telefone:</label>
                            <input type="text" class="form-control" id="telefone" name="telefone">
                        </div>
                        <div class="col-12 col-md-4">
                            <label for="email" class="form-label fw-bold">E-mail:</label>
                            <input type="email" class="form-control" id="email" name="email">
                        </div>
                    </div>

                    <h4 class="mb-3 mt-4 border-bottom pb-2 text-secondary"><i class="fas fa-map-marker-alt me-2"></i>
                        Endereço</h4>
                    <div class="row g-3">
                        <div class="col-12">
                            <label for="endereco" class="form-label fw-bold">Endereço:</label>
                            <input type="text" class="form-control" id="endereco" name="endereco">
                        </div>
                        <div class="col-12 col-md-6">
                            <label for="bairro" class="form-label fw-bold">Bairro:</label>
                            <input type="text" class="form-control" id="bairro" name="bairro" list="lista-bairros"
                                placeholder="Digite ou selecione...">
                            <datalist id="lista-bairros">
                                <?php foreach ($bairros as $b): ?>
                                    <option value="<?= htmlspecialchars($b) ?>">
                                    <?php endforeach; ?>
                            </datalist>
                        </div>
                        <div class="col-12 col-md-3">
                            <label for="cidade" class="form-label fw-bold">Cidade:</label>
                            <input type="text" class="form-control" id="cidade" name="cidade" value="Belém">
                        </div>
                        <div class="col-6 col-md-1">
                            <label for="uf" class="form-label fw-bold">UF:</label>
                            <input type="text" class="form-control" id="uf" name="uf" value="PA" maxlength="2">
                        </div>
                        <div class="col-6 col-md-2">
                            <label for="cep" class="form-label fw-bold">CEP:</label>
                            <input type="text" class="form-control" id="cep" name="cep">
                        </div>
                    </div>

                    <!-- SEÇÃO DE DEMANDA ADICIONADA -->
                    <h4 class="mb-3 mt-4 border-bottom pb-2 text-secondary"><i class="fas fa-bullhorn me-2"></i> Demanda
                        Inicial (Opcional)</h4>
                    <p class="text-muted">Se houver uma demanda inicial para este eleitor, preencha os campos abaixo.
                    </p>

                    <div class="row g-3">
                        <div class="col-12 col-md-6">
                            <label for="demanda_categoria" class="form-label fw-bold">Categoria da Demanda:</label>
                            <select class="form-select" id="demanda_categoria" name="demanda[categoria]">
                                <option value="">Nenhuma demanda</option>
                                <option value="Saúde">Saúde</option>
                                <option value="Jurídico">Jurídico</option>
                                <option value="Assistência Social">Assistência Social</option>
                                <option value="Ação Social">Ação Social</option>
                                <option value="Reunião">Reunião</option>
                                <option value="Visita">Visita</option>
                            </select>
                        </div>
                        <div class="col-12 col-md-6">
                            <label for="demanda_titulo" class="form-label fw-bold">Título da Demanda:</label>
                            <input type="text" class="form-control" id="demanda_titulo" name="demanda[titulo]"
                                placeholder="Ex: Agendamento de consulta">
                        </div>
                        <div class="col-12">
                            <label for="demanda_descricao" class="form-label fw-bold">Descrição da Demanda:</label>
                            <textarea class="form-control" id="demanda_descricao" name="demanda[descricao]"
                                rows="3"></textarea>
                        </div>
                    </div>

                    <h4 class="mb-3 mt-4 border-bottom pb-2 text-secondary"><i class="fas fa-info-circle me-2"></i>
                        Outras Informações</h4>
                    <div class="row g-3">
                        <div class="col-12 col-md-6">
                            <label for="sexo" class="form-label fw-bold">Sexo:</label>
                            <select class="form-select" id="sexo" name="sexo">
                                <option value="">Selecione...</option>
                                <option value="Masculino">Masculino</option>
                                <option value="Feminino">Feminino</option>
                                <option value="Outro">Outro</option>
                            </select>
                        </div>
                        <div class="col-12 col-md-6">
                            <label for="tipo" class="form-label fw-bold">Tipo:</label>
                            <select class="form-select" id="tipo" name="tipo" required>
                                <option value="Apoiador">Apoiador</option>
                                <option value="Liderança">Liderança</option>
                            </select>
                        </div>
                        <div class="col-12">
                            <label for="observacao" class="form-label fw-bold">Observação Geral:</label>
                            <textarea class="form-control" id="observacao" name="observacao" rows="4"></textarea>
                        </div>
                    </div>

                    <div class="mt-4 text-end">
                        <button type="submit" class="btn btn-primary">Salvar Eleitor</button>
                        <a href="<?= $BASE_URL ?>/src/views/eleitores/lista.php" class="btn btn-secondary">Cancelar</a>
                    </div>
                </form>
            </div>

        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

    <script>
        // Função para consulta de CEP e autopreenchimento
        document.getElementById('cep').addEventListener('blur', function () {
            // Limpa o CEP para deixar apenas números
            let cep = this.value.replace(/\D/g, '');

            // Verifica se o CEP tem 8 dígitos
            if (cep.length !== 8) {
                return;
            }

            // Mostra indicador de carregamento
            this.value = 'Buscando...';

            // Faz a consulta à API ViaCEP
            fetch(`https://viacep.com.br/ws/${cep}/json/`)
                .then(response => response.json())
                .then(data => {
                    // Verifica se a API retornou erro
                    if (data.erro) {
                        alert('CEP não encontrado');
                        document.getElementById('cep').value = '';
                        return;
                    }

                    // Preenche os campos com os dados retornados
                    document.getElementById('cep').value = cep;
                    document.getElementById('endereco').value = data.logradouro;
                    document.getElementById('bairro').value = data.bairro;
                    document.getElementById('cidade').value = data.localidade;
                    document.getElementById('uf').value = data.uf;

                    // Foca no próximo campo a ser preenchido
                    document.getElementById('endereco').focus();
                })
                .catch(error => {
                    alert('Erro ao consultar o CEP. Tente novamente.');
                    document.getElementById('cep').value = '';
                });
        });

        // Formata o CEP enquanto digita
        document.getElementById('cep').addEventListener('input', function () {
            this.value = this.value.replace(/\D/g, '');
            if (this.value.length > 8) {
                this.value = this.value.substring(0, 8);
            }
        });
    </script>
</body>

</html>