<?php
// reset_admin_password.php
// Script para redefinir a senha do administrador ou criar o usuário se não existir

error_reporting(E_ALL);
ini_set('display_errors', 1);

require_once __DIR__ . '/src/config/db.php';

$email = 'admin@gabinete.com';
$senha_plana = 'admin123';
$hash = password_hash($senha_plana, PASSWORD_DEFAULT);

echo "<h1>Redefinição de Senha de Admin</h1>";

try {
    // 1. Tentar atualizar usuário existente
    echo "<p>Tentando atualizar usuário <strong>$email</strong>...</p>";
    $stmt = $pdo->prepare("UPDATE usuarios SET senha = :senha, nivelacesso = 'Admin', ativo = 1 WHERE email = :email");
    $stmt->execute([':senha' => $hash, ':email' => $email]);

    if ($stmt->rowCount() > 0) {
        echo "<p style='color:green'>SUCESSO: Senha atualizada para '<strong>$senha_plana</strong>'.</p>";
    } else {
        // 2. Se não atualizou, verifica se existe
        $stmt = $pdo->prepare("SELECT id FROM usuarios WHERE email = :email");
        $stmt->execute([':email' => $email]);

        if ($stmt->fetch()) {
            echo "<p style='color:orange'>O usuário existe, mas a senha já era essa ou não houve mudança.</p>";
        } else {
            // 3. Se não existe, cria
            echo "<p>Usuário não encontrado. Criando novo...</p>";
            $stmt = $pdo->prepare("INSERT INTO usuarios (nome, email, senha, nivelacesso, ativo) VALUES (:nome, :email, :senha, 'Admin', 1)");
            $stmt->execute([
                ':nome' => 'Administrador',
                ':email' => $email,
                ':senha' => $hash
            ]);
            echo "<p style='color:green'>SUCESSO: Usuário criado com senha '<strong>$senha_plana</strong>'.</p>";
        }
    }

    echo "<hr>";
    echo "<p>Agora você pode tentar fazer login em <a href='login.php'>login.php</a>.</p>";
    echo "<p><strong>IMPORTANTE: Apague este arquivo do servidor após o uso por segurança!</strong></p>";

} catch (PDOException $e) {
    echo "<p style='color:red'>ERRO NO BANCO DE DADOS: " . $e->getMessage() . "</p>";
}
?>