<?php

// Voter registration handler - Direct database approach
header('Content-Type: application/json; charset=utf-8');

try {
    // Get the form data
    $nome_completo = $_POST['nome_completo'] ?? '';
    $telefone = $_POST['telefone'] ?? '';
    $email = $_POST['email'] ?? '';
    $endereco = $_POST['endereco'] ?? '';
    $bairro = $_POST['bairro'] ?? '';
    $cidade = $_POST['cidade'] ?? '';
    $uf = $_POST['uf'] ?? '';
    $cep = $_POST['cep'] ?? '';
    $sexo = $_POST['sexo'] ?? '';
    $tipo = $_POST['tipo'] ?? '';
    $observacao = $_POST['observacao'] ?? '';
    
    // Validate required fields
    if (empty($nome_completo)) {
        throw new Exception('Nome completo é obrigatório');
    }
    
    // Database connection with credentials from config
    $host = 'localhost';
    $db = 'aurydona_gabinete_db';
    $user = 'aurydona_gabinete';
    $pass = 'Aury@25!';
    
    $mysqli = new mysqli($host, $user, $pass, $db);
    
    if ($mysqli->connect_error) {
        throw new Exception('Erro de conexão: ' . $mysqli->connect_error);
    }
    
    $mysqli->set_charset('utf8mb4');
    
    // Insert into database
    $stmt = $mysqli->prepare("INSERT INTO eleitores (nome_completo, telefone, email, endereco, bairro, cidade, uf, cep, sexo, tipo, observacao) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    
    if (!$stmt) {
        throw new Exception('Erro na preparação: ' . $mysqli->error);
    }
    
    $stmt->bind_param('sssssssssss', $nome_completo, $telefone, $email, $endereco, $bairro, $cidade, $uf, $cep, $sexo, $tipo, $observacao);
    
    if (!$stmt->execute()) {
        throw new Exception('Erro na execução: ' . $stmt->error);
    }
    
    $lastId = $stmt->insert_id;
    $stmt->close();
    $mysqli->close();
    
    // Return success and redirect to lista.php  
    echo json_encode([
        'success' => true,
        'message' => 'Eleitor cadastrado com sucesso!',
        'id' => $lastId
    ]);
    header('Location: /public_html/src/views/eleitores/lista.php', true, 303);
    exit;
    
} catch (Exception $e) {
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
    exit;
}

?>