<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }
$BASE_PATH = '/gabinete';
if (empty($_SESSION['user_id'])) {
  header('Location: '.$BASE_PATH.'/login.php', true, 302);
  exit;
}

/**
 * Em vez de incluir, este index APENAS REDIRECIONA
 * para os arquivos completos já existentes no módulo.
 * Isso evita quebra de CSS/JS/headers dos seus arquivos prontos.
 */

$routes = array(
  'lista'    => $BASE_PATH . '/src/views/eleitores/lista.php',
  'create'   => $BASE_PATH . '/src/views/eleitores/create.php',
  'detalhes' => $BASE_PATH . '/src/views/eleitores/detalhes.php',
  'form'     => $BASE_PATH . '/src/views/eleitores/form.php',
  'editar'   => $BASE_PATH . '/src/views/eleitores/editar.php',
);

$p = isset($_GET['p']) ? strtolower(preg_replace('/[^a-z0-9_]/i','', $_GET['p'])) : 'lista';

$destino = isset($routes[$p]) ? $routes[$p] : $routes['lista'];

// Redireciona 302 para a página real
header('Location: '.$destino, true, 302);
exit;
