<?php
/**
 * Controller da Página Inicial para usuários não logados.
 * Sua única função é redirecionar para a página de login.
 */
class HomeController {

    /**
     * Método padrão que executa o redirecionamento.
     * Este método é chamado quando um usuário não logado acessa a URL raiz do site.
     */
    public function index() {
        // Redireciona para a rota de login, que será gerenciada pelo UsuarioController.
        // Usamos a constante BASE_URL definida no config.php para criar um link absoluto e confiável.
        header('Location: ' . BASE_URL . '/usuario/login');
        // Encerra a execução do script para garantir que o redirecionamento ocorra imediatamente.
        exit(); 
    }
}
