# Copilot Instructions for Gabinete

## Visão Geral
Este projeto é um sistema web de gestão de gabinete político, desenvolvido em PHP seguindo o padrão MVC. Ele integra módulos para agenda, documentos, eleitores, relatórios e administração, com forte uso de controllers, models e views em `src/`.

## Estrutura e Fluxo
- **MVC:**
  - Controllers em `src/controllers/` (ex: `AgendasController.php`, `DocumentosController.php`)
  - Models em `src/models/` (ex: `Usuario.php`, `Documento.php`)
  - Views em `src/views/` (subpastas por módulo)
- **Configuração:**
  - Banco de dados e logs em `src/config/`
  - Autenticação via `helpers/AuthHelper.php`
- **Uploads:**
  - Documentos e arquivos em `uploads/` e `public/uploads/`
- **Roteamento:**
  - Entrada principal via `index.php`, roteando para controllers conforme parâmetros da URL

## Convenções Específicas
- Controllers usam métodos públicos para ações (ex: `index`, `create`, `edit`, `delete`)
- Models representam entidades do banco, com métodos para CRUD e consultas customizadas
- Views são fragmentadas em `partials` para componentes reutilizáveis
- Autenticação e controle de acesso são feitos por helper e checados nos controllers
- Logs de auditoria em `src/config/log.php`
- Integração opcional com Google Calendar e exportação de relatórios em PDF

## Workflows de Desenvolvimento
- **Banco de dados:**
  - Scripts SQL em `sql/` para criação e atualização de tabelas
  - Conexão via PDO, configurada em `src/config/config.php`
- **Debug:**
  - Arquivos de teste e debug em raiz (`debug_session.php`, `test_dashboard_direct.php`)
  - Logs detalhados em `src/config/log.php`
- **Testes:**
  - Não há framework de testes automatizados; testes são feitos via scripts PHP e inspeção manual
- **Build/Deploy:**
  - Não há build automatizado; deploy é feito por upload dos arquivos ao servidor
  - Recomenda-se uso de MAMP/XAMPP para ambiente local

## Integrações e Dependências
- Google Calendar (opcional, via controller)
- Exportação PDF (biblioteca PHP, verificar dependências em `composer.json`)
- Requer PHP >=7.4, MySQL >=5.7, Apache/Nginx

## Exemplos de Padrões
- Para adicionar um novo módulo, crie controller, model e views correspondentes em `src/`
- Para novas tabelas, adicione script SQL em `sql/` e atualize o model
- Para autenticação, use métodos do `AuthHelper.php` e cheque permissões nos controllers

## Referências de Arquivos
- `src/controllers/` — lógica de cada módulo
- `src/models/` — entidades e acesso ao banco
- `src/views/` — interfaces e componentes
- `src/config/config.php` — configuração global
- `sql/` — scripts de banco de dados
- `uploads/` — arquivos enviados

---

> Atualize este documento conforme novas convenções ou integrações forem implementadas.
