<div class="content-box">
    <h1><i class="fas fa-user-plus"></i> Criar Novo Usuário</h1>
    
    <div class="page-actions">
        <a href="<?= BASE_URL ?>/paineladmin/usuarios" class="btn btn-secondary">
            <i class="fas fa-arrow-left"></i> Voltar para Usuários
        </a>
    </div>

    <form action="<?= BASE_URL ?>/paineladmin/criarUsuario" method="POST" class="user-form">
        <div class="form-group">
            <label for="nome">Nome Completo:</label>
            <input type="text" id="nome" name="nome" required>
        </div>

        <div class="form-group">
            <label for="email">Email:</label>
            <input type="email" id="email" name="email" required>
        </div>

        <div class="form-group">
            <label for="senha">Senha:</label>
            <input type="password" id="senha" name="senha" required minlength="6">
            <small>Mínimo de 6 caracteres</small>
        </div>

        <div class="form-group">
            <label for="nivel_acesso">Nível de Acesso:</label>
            <select id="nivel_acesso" name="nivel_acesso" required>
                <option value="">Selecione...</option>
                <option value="Admin">Administrador</option>
                <option value="Assessor">Assessor</option>
                <option value="Estagiario">Estagiário</option>
            </select>
        </div>

        <div class="form-actions">
            <button type="submit" class="btn btn-success">
                <i class="fas fa-save"></i> Criar Usuário
            </button>
            <a href="<?= BASE_URL ?>/paineladmin/usuarios" class="btn btn-secondary">
                Cancelar
            </a>
        </div>
    </form>
</div>

<style>
.user-form {
    max-width: 500px;
    margin: 20px auto;
    background: white;
    padding: 30px;
    border-radius: 8px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.05);
}

.form-group {
    margin-bottom: 20px;
}

.form-group label {
    display: block;
    margin-bottom: 5px;
    font-weight: bold;
    color: #333;
}

.form-group input,
.form-group select {
    width: 100%;
    padding: 10px;
    border: 1px solid #ddd;
    border-radius: 4px;
    font-size: 16px;
    box-sizing: border-box;
}

.form-group small {
    color: #666;
    font-size: 0.9em;
    margin-top: 5px;
    display: block;
}

.form-actions {
    display: flex;
    gap: 10px;
    justify-content: flex-end;
    margin-top: 30px;
}
</style>
