<?php
// create.php — Página Novo Colaborador com layout Tailwind
$pageTitle = 'Novo Colaborador';
require_once __DIR__ . '/../partials/header.php';
?>

<!-- Topo com breadcrumb -->
<div class="bg-white border-b">
  <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-6">
    <nav class="text-sm text-slate-500" aria-label="Breadcrumb">
      <ol class="flex items-center gap-2">
        <li>
          <a href="<?= BASE_URL ?>/employees" class="hover:text-slate-700 inline-flex items-center gap-1">
            <svg class="h-4 w-4" viewBox="0 0 20 20" fill="currentColor" aria-hidden="true"><path d="M10.707 2.293a1 1 0 00-1.414 0l-7 7a1 1 0 001.414 1.414L4 10.414V17a1 1 0 001 1h3a1 1 0 001-1v-3a1 1 0 112 0v3a1 1 0 001 1h3a1 1 0 001-1v-6.586l.293.293A1 1 0 0018.121 9.7l-7-7z"/></svg>
            Colaboradores
          </a>
        </li>
        <li class="text-slate-300">/</li>
        <li class="text-slate-900 font-medium">Novo Colaborador</li>
      </ol>
    </nav>
    <h1 class="mt-3 text-2xl sm:text-3xl font-bold text-slate-900">Novo Colaborador</h1>
    <p class="mt-1 text-slate-600">Preencha os dados para cadastrar um novo colaborador.</p>
  </div>
</div>

<!-- Conteúdo -->
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">

  <!-- Alertas -->
  <?php if (!empty($_SESSION['errors'])): ?>
    <div class="rounded-md bg-red-50 p-4 mb-6 border border-red-200" role="alert">
      <div class="flex">
        <div class="flex-shrink-0" aria-hidden="true">
          <svg class="h-5 w-5 text-red-500" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm.75-11.75a.75.75 0 00-1.5 0v5a.75.75 0 001.5 0v-5zM10 14.75a.75.75 0 100 1.5.75.75 0 000-1.5z" clip-rule="evenodd"/></svg>
        </div>
        <div class="ml-3">
          <h3 class="text-sm font-medium text-red-800">Corrija os seguintes erros:</h3>
          <ul class="mt-2 text-sm text-red-700 list-disc pl-5 space-y-1">
            <?php foreach ($_SESSION['errors'] as $error): ?>
              <li><?= htmlspecialchars($error) ?></li>
            <?php endforeach; ?>
          </ul>
        </div>
      </div>
    </div>
    <?php unset($_SESSION['errors']); ?>
  <?php endif; ?>

  <form method="POST" action="<?= BASE_URL ?>/employees/store" class="grid lg:grid-cols-12 gap-6" novalidate>
    <!-- Coluna principal -->
    <div class="lg:col-span-9 space-y-6">

      <!-- Dados Pessoais -->
      <section class="bg-white rounded-xl shadow-sm ring-1 ring-slate-200 p-6">
        <h2 class="text-base font-semibold text-slate-900">Dados Pessoais</h2>
        <p class="text-sm text-slate-500 mb-4">Informações básicas do colaborador.</p>
        <div class="grid grid-cols-6 gap-4">
          <div class="col-span-6 sm:col-span-4">
            <label for="full_name" class="block text-sm font-medium text-slate-700">Nome completo *</label>
            <input type="text" id="full_name" name="full_name" required autocomplete="name"
                   value="<?= htmlspecialchars($_SESSION['old']['full_name'] ?? '') ?>"
                   class="mt-1 block w-full rounded-lg border-slate-300 focus:border-indigo-500 focus:ring-indigo-500">
          </div>
          <div class="col-span-6 sm:col-span-2">
            <label for="birth_date" class="block text-sm font-medium text-slate-700">Data de nascimento</label>
            <input type="date" id="birth_date" name="birth_date"
                   value="<?= htmlspecialchars($_SESSION['old']['birth_date'] ?? '') ?>"
                   class="mt-1 block w-full rounded-lg border-slate-300 focus:border-indigo-500 focus:ring-indigo-500">
          </div>
          <div class="col-span-6 sm:col-span-3">
            <label for="cpf" class="block text-sm font-medium text-slate-700">CPF *</label>
            <input type="text" id="cpf" name="cpf" required inputmode="numeric" placeholder="000.000.000-00"
                   value="<?= htmlspecialchars($_SESSION['old']['cpf'] ?? '') ?>"
                   class="mt-1 block w-full rounded-lg border-slate-300 focus:border-indigo-500 focus:ring-indigo-500">
          </div>
          <div class="col-span-6 sm:col-span-3">
            <label for="rg" class="block text-sm font-medium text-slate-700">RG</label>
            <input type="text" id="rg" name="rg"
                   value="<?= htmlspecialchars($_SESSION['old']['rg'] ?? '') ?>"
                   class="mt-1 block w-full rounded-lg border-slate-300 focus:border-indigo-500 focus:ring-indigo-500">
          </div>
          <div class="col-span-6 sm:col-span-3">
            <label for="phone_number" class="block text-sm font-medium text-slate-700">Telefone</label>
            <input type="text" id="phone_number" name="phone_number" placeholder="(00) 00000-0000"
                   value="<?= htmlspecialchars($_SESSION['old']['phone_number'] ?? '') ?>"
                   class="mt-1 block w-full rounded-lg border-slate-300 focus:border-indigo-500 focus:ring-indigo-500">
          </div>
          <div class="col-span-6">
            <label for="address" class="block text-sm font-medium text-slate-700">Endereço</label>
            <textarea id="address" name="address" rows="3"
                      class="mt-1 block w-full rounded-lg border-slate-300 focus:border-indigo-500 focus:ring-indigo-500"><?= htmlspecialchars($_SESSION['old']['address'] ?? '') ?></textarea>
          </div>
        </div>
      </section>

      <!-- Dados Contratuais -->
      <section class="bg-white rounded-xl shadow-sm ring-1 ring-slate-200 p-6">
        <h2 class="text-base font-semibold text-slate-900">Dados Contratuais</h2>
        <p class="text-sm text-slate-500 mb-4">Informações sobre o contrato de trabalho.</p>
        <div class="grid grid-cols-6 gap-4">
          <div class="col-span-6 sm:col-span-3">
            <label for="job_title" class="block text-sm font-medium text-slate-700">Cargo *</label>
            <input type="text" id="job_title" name="job_title" required
                   value="<?= htmlspecialchars($_SESSION['old']['job_title'] ?? '') ?>"
                   class="mt-1 block w-full rounded-lg border-slate-300 focus:border-indigo-500 focus:ring-indigo-500">
          </div>
          <div class="col-span-6 sm:col-span-3">
            <label for="salary" class="block text-sm font-medium text-slate-700">Salário *</label>
            <div class="mt-1 relative">
              <span class="absolute inset-y-0 left-0 pl-3 flex items-center text-slate-500">R$</span>
              <input type="text" id="salary" name="salary" required placeholder="0,00"
                     value="<?= htmlspecialchars($_SESSION['old']['salary'] ?? '') ?>"
                     class="pl-8 block w-full rounded-lg border-slate-300 focus:border-indigo-500 focus:ring-indigo-500">
            </div>
          </div>
          <div class="col-span-6 sm:col-span-3">
            <label for="hire_date" class="block text-sm font-medium text-slate-700">Data de admissão</label>
            <input type="date" id="hire_date" name="hire_date"
                   value="<?= htmlspecialchars($_SESSION['old']['hire_date'] ?? '') ?>"
                   class="mt-1 block w-full rounded-lg border-slate-300 focus:border-indigo-500 focus:ring-indigo-500">
          </div>
          <div class="col-span-6 sm:col-span-3">
            <label for="contract_type" class="block text-sm font-medium text-slate-700">Tipo de contrato</label>
            <select id="contract_type" name="contract_type"
                    class="mt-1 block w-full rounded-lg border-slate-300 focus:border-indigo-500 focus:ring-indigo-500">
              <?php $ct = $_SESSION['old']['contract_type'] ?? 'CLT'; ?>
              <option value="CLT" <?= ($ct==='CLT'?'selected':'') ?>>CLT</option>
              <option value="PJ" <?= ($ct==='PJ'?'selected':'') ?>>PJ</option>
              <option value="Estágio" <?= ($ct==='Estágio'?'selected':'') ?>>Estágio</option>
            </select>
          </div>
          <div class="col-span-6 sm:col-span-3">
            <label for="cost_center" class="block text-sm font-medium text-slate-700">Centro de custo</label>
            <input type="text" id="cost_center" name="cost_center"
                   value="<?= htmlspecialchars($_SESSION['old']['cost_center'] ?? '') ?>"
                   class="mt-1 block w-full rounded-lg border-slate-300 focus:border-indigo-500 focus:ring-indigo-500">
          </div>
          <div class="col-span-6 sm:col-span-3">
            <label for="status" class="block text-sm font-medium text-slate-700">Status</label>
            <?php $st = $_SESSION['old']['status'] ?? 'ativo'; ?>
            <select id="status" name="status" class="mt-1 block w-full rounded-lg border-slate-300 focus:border-indigo-500 focus:ring-indigo-500">
              <option value="ativo" <?= ($st==='ativo'?'selected':'') ?>>Ativo</option>
              <option value="inativo" <?= ($st==='inativo'?'selected':'') ?>>Inativo</option>
            </select>
          </div>
        </div>
      </section>

      <!-- Dados Bancários -->
      <section class="bg-white rounded-xl shadow-sm ring-1 ring-slate-200 p-6">
        <h2 class="text-base font-semibold text-slate-900">Dados Bancários</h2>
        <p class="text-sm text-slate-500 mb-4">Informações para folha de pagamento.</p>
        <div class="grid grid-cols-6 gap-4">
          <div class="col-span-6 sm:col-span-3">
            <label for="bank_name" class="block text-sm font-medium text-slate-700">Banco</label>
            <input type="text" id="bank_name" name="bank_name"
                   value="<?= htmlspecialchars($_SESSION['old']['bank_name'] ?? '') ?>"
                   class="mt-1 block w-full rounded-lg border-slate-300 focus:border-indigo-500 focus:ring-indigo-500">
          </div>
          <div class="col-span-6 sm:col-span-3">
            <label for="agency_number" class="block text-sm font-medium text-slate-700">Agência</label>
            <input type="text" id="agency_number" name="agency_number"
                   value="<?= htmlspecialchars($_SESSION['old']['agency_number'] ?? '') ?>"
                   class="mt-1 block w-full rounded-lg border-slate-300 focus:border-indigo-500 focus:ring-indigo-500">
          </div>
          <div class="col-span-6 sm:col-span-3">
            <label for="account_number" class="block text-sm font-medium text-slate-700">Conta</label>
            <input type="text" id="account_number" name="account_number"
                   value="<?= htmlspecialchars($_SESSION['old']['account_number'] ?? '') ?>"
                   class="mt-1 block w-full rounded-lg border-slate-300 focus:border-indigo-500 focus:ring-indigo-500">
          </div>
        </div>
      </section>

    </div>

    <!-- Coluna lateral (sticky) -->
    <aside class="lg:col-span-3">
      <div class="lg:sticky lg:top-6 space-y-4">
        <div class="bg-white rounded-xl shadow-sm ring-1 ring-slate-200 p-4">
          <h3 class="text-sm font-semibold text-slate-900">Ações</h3>
          <p class="text-xs text-slate-500 mb-3">Revise os dados antes de salvar.</p>
          <div class="flex gap-2">
            <a href="<?= BASE_URL ?>/employees" class="inline-flex items-center justify-center rounded-lg border border-slate-300 px-3 py-2 text-sm text-slate-700 hover:bg-slate-50">Cancelar</a>
            <button type="submit" class="inline-flex items-center justify-center rounded-lg bg-indigo-600 px-4 py-2 text-sm font-medium text-white hover:bg-indigo-700 focus:outline-none focus:ring-2 focus:ring-indigo-500">
              Salvar cadastro
            </button>
          </div>
        </div>
        <div class="bg-indigo-50 border border-indigo-200 rounded-xl p-4">
          <p class="text-xs text-indigo-800">Campos marcados com * são obrigatórios.</p>
        </div>
      </div>
    </aside>
  </form>
</div>

<script>
// Máscara simples de moeda (R$)
const salaryInput = document.getElementById('salary');
if (salaryInput) {
  salaryInput.addEventListener('input', (e) => {
    let v = e.target.value.replace(/\D/g, '');
    if (!v) { e.target.value = ''; return; }
    v = (parseInt(v,10) / 100).toFixed(2).replace('.', ',');
    v = v.replace(/(\d)(?=(\d{3})+(?!\d))/g, '$1.');
    e.target.value = v;
  });
}

// Máscaras de CPF e telefone
function maskCPF(value){
  return value
    .replace(/\D/g, '')
    .replace(/(\d{3})(\d)/, '$1.$2')
    .replace(/(\d{3})(\d)/, '$1.$2')
    .replace(/(\d{3})(\d{1,2})$/, '$1-$2')
    .slice(0,14);
}
function maskPhone(v){
  v = v.replace(/\D/g, '');
  if (v.length > 10) {
    return v.replace(/(\d{2})(\d{5})(\d{4}).*/, '($1) $2-$3');
  }
  return v.replace(/(\d{2})(\d{4})(\d{0,4}).*/, '($1) $2-$3');
}

const cpf = document.getElementById('cpf');
if (cpf) cpf.addEventListener('input', e => e.target.value = maskCPF(e.target.value));
const tel = document.getElementById('phone_number');
if (tel) tel.addEventListener('input', e => e.target.value = maskPhone(e.target.value));
</script>

<?php unset($_SESSION['old']); require_once __DIR__ . '/../partials/footer.php'; ?>
