<div class="content-box">
    <h1><i class="fas fa-user-edit"></i> Editar Eleitor</h1>
    <p>Atualize os dados do eleitor <?= htmlspecialchars($eleitor['nome_completo']) ?>.</p>

    <form action="<?= BASE_URL ?>/eleitores/atualizar/<?= $eleitor['id'] ?>" method="POST" class="form-container">
        
        <h2><i class="fas fa-id-card"></i> Dados Pessoais</h2>
        <div class="form-row">
            <div class="form-group col-md-8">
                <label for="nome_completo">Nome Completo:</label>
                <input type="text" id="nome_completo" name="nome_completo" value="<?= htmlspecialchars($eleitor['nome_completo']) ?>" required>
            </div>
            <div class="form-group col-md-4">
                <label for="data_nascimento">Data de Nascimento:</label>
                <input type="date" id="data_nascimento" name="data_nascimento" value="<?= $eleitor['data_nascimento'] ?>">
            </div>
        </div>

        <div class="form-row">
            <div class="form-group col-md-4">
                <label for="telefone">Telefone:</label>
                <input type="text" id="telefone" name="telefone" value="<?= htmlspecialchars($eleitor['telefone'] ?? '') ?>">
            </div>
            <div class="form-group col-md-8">
                <label for="email">E-mail:</label>
                <input type="email" id="email" name="email" value="<?= htmlspecialchars($eleitor['email'] ?? '') ?>">
            </div>
        </div>
        
        <hr>

        <h2><i class="fas fa-map-marker-alt"></i> Endereço</h2>
        <div class="form-row">
             <div class="form-group col-md-12">
                <label for="endereco">Endereço:</label>
                <input type="text" id="endereco" name="endereco" value="<?= htmlspecialchars($eleitor['endereco'] ?? '') ?>">
            </div>
        </div>

        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="bairro">Bairro:</label>
                <input type="text" id="bairro" name="bairro" value="<?= htmlspecialchars($eleitor['bairro'] ?? '') ?>">
            </div>
            <div class="form-group col-md-4">
                <label for="cidade">Cidade:</label>
                <input type="text" id="cidade" name="cidade" value="Belém" readonly>
            </div>
             <div class="form-group col-md-2">
                <label for="cep">CEP:</label>
                <input type="text" id="cep" name="cep" value="<?= htmlspecialchars($eleitor['cep'] ?? '') ?>">
            </div>
        </div>

        <hr>

        <h2><i class="fas fa-info-circle"></i> Outras Informações</h2>
        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="sexo">Sexo:</label>
                <select id="sexo" name="sexo">
                    <option value="">Selecione...</option>
                    <option value="Masculino" <?= ($eleitor['sexo'] ?? '') === 'Masculino' ? 'selected' : '' ?>>Masculino</option>
                    <option value="Feminino" <?= ($eleitor['sexo'] ?? '') === 'Feminino' ? 'selected' : '' ?>>Feminino</option>
                    <option value="Outro" <?= ($eleitor['sexo'] ?? '') === 'Outro' ? 'selected' : '' ?>>Outro</option>
                </select>
            </div>
            <div class="form-group col-md-6">
                <label for="tipo">Tipo:</label>
                <select id="tipo" name="tipo" required>
                    <option value="Apoiador" <?= ($eleitor['tipo'] ?? '') === 'Apoiador' ? 'selected' : '' ?>>Apoiador</option>
                    <option value="Liderança" <?= ($eleitor['tipo'] ?? '') === 'Liderança' ? 'selected' : '' ?>>Liderança</option>
                </select>
            </div>
        </div>

        <div class="form-group">
            <label for="observacao">Observação Geral:</label>
            <textarea id="observacao" name="observacao" rows="4"><?= htmlspecialchars($eleitor['observacao'] ?? '') ?></textarea>
        </div>

        <div class="form-actions">
            <button type="submit" class="btn-primary">
                <i class="fas fa-save"></i> Atualizar Eleitor
            </button>
            <a href="<?= BASE_URL ?>/eleitores/ver/<?= $eleitor['id'] ?>" class="btn-secondary">
                <i class="fas fa-eye"></i> Ver Detalhes
            </a>
            <a href="<?= BASE_URL ?>/eleitores" class="btn-secondary">
                <i class="fas fa-arrow-left"></i> Voltar à Lista
            </a>
        </div>
    </form>
</div>

<style>
    .form-container { max-width: 800px; margin: auto; }
    .form-container h2 {
        font-size: 1.2em;
        color: #333;
        border-bottom: 2px solid #f0f0f0;
        padding-bottom: 5px;
        margin-top: 25px;
        margin-bottom: 20px;
    }
    .form-container h2 i {
        margin-right: 8px;
        color: #337ab7;
    }
    .form-row { display: flex; flex-wrap: wrap; margin-left: -10px; margin-right: -10px; }
    .form-group { padding: 0 10px; margin-bottom: 15px; flex-grow: 1; }
    .col-md-2 { flex-basis: 16.66%; }
    .col-md-4 { flex-basis: 33.33%; }
    .col-md-6 { flex-basis: 50%; }
    .col-md-8 { flex-basis: 66.66%; }
    .col-md-12 { flex-basis: 100%; }
    .form-group label { display: block; margin-bottom: 5px; font-weight: bold; }
    .form-group input, .form-group select, .form-group textarea {
        width: 100%;
        padding: 10px;
        border: 1px solid #ccc;
        border-radius: 4px;
        box-sizing: border-box;
    }
    .form-group input[readonly] {
        background-color: #f8f9fa;
        color: #6c757d;
    }
    .form-actions { 
        text-align: right; 
        margin-top: 20px;
        display: flex;
        gap: 10px;
        justify-content: flex-end;
    }
    .btn-primary, .btn-secondary {
        padding: 10px 20px;
        border: none;
        border-radius: 5px;
        color: white;
        text-decoration: none;
        cursor: pointer;
        font-weight: bold;
        display: inline-flex;
        align-items: center;
        gap: 5px;
    }
    .btn-primary { background-color: #28a745; }
    .btn-primary:hover { background-color: #218838; }
    .btn-secondary { background-color: #6c757d; }
    .btn-secondary:hover { background-color: #5a6268; }
</style>