<div class="content-box">
    <h1><i class="fas fa-user-plus"></i> Cadastrar Cliente</h1>
    <p>Preencha os dados abaixo para adicionar um novo eleitor ao sistema.</p>

    <form action="<?= BASE_URL ?>/eleitores/store" method="POST" class="form-container">
        
        <h2><i class="fas fa-id-card"></i> Dados Pessoais</h2>
        <div class="form-row">
            <div class="form-group col-md-8">
                <label for="nome_completo">Nome Completo:</label>
                <input type="text" id="nome_completo" name="nome_completo" required>
            </div>
            <div class="form-group col-md-4">
                <label for="data_nascimento">Data de Nascimento:</label>
                <input type="date" id="data_nascimento" name="data_nascimento">
            </div>
        </div>

        <div class="form-row">
            <div class="form-group col-md-4">
                <label for="telefone">Telefone:</label>
                <input type="text" id="telefone" name="telefone">
            </div>
            <div class="form-group col-md-8">
                <label for="email">E-mail:</label>
                <input type="email" id="email" name="email">
            </div>
        </div>
        
        <hr>

        <h2><i class="fas fa-map-marker-alt"></i> Endereço</h2>
        <div class="form-row">
             <div class="form-group col-md-12">
                <label for="endereco">Endereço:</label>
                <input type="text" id="endereco" name="endereco">
            </div>
        </div>

        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="bairro">Bairro:</label>
                <input type="text" id="bairro" name="bairro">
            </div>
            <div class="form-group col-md-4">
                <label for="cidade">Cidade:</label>
                <input type="text" id="cidade" name="cidade" value="Belém">
            </div>
             <div class="form-group col-md-2">
                <label for="cep">CEP:</label>
                <input type="text" id="cep" name="cep">
            </div>
        </div>

        <hr>
        
        <!-- SEÇÃO DE DEMANDA ADICIONADA -->
        <h2><i class="fas fa-bullhorn"></i> Demanda Inicial (Opcional)</h2>
        <p>Se houver uma demanda inicial para este eleitor, preencha os campos abaixo.</p>

        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="demanda_categoria">Categoria da Demanda:</label>
                <select id="demanda_categoria" name="demanda[categoria]">
                    <option value="">Nenhuma demanda</option>
                    <option value="Saúde">Saúde</option>
                    <option value="Jurídico">Jurídico</option>
                    <option value="Assistência Social">Assistência Social</option>
                    <option value="Ação Social">Ação Social</option>
                    <option value="Reunião">Reunião</option>
                    <option value="Visita">Visita</option>
                </select>
            </div>
            <div class="form-group col-md-6">
                <label for="demanda_titulo">Título da Demanda:</label>
                <input type="text" id="demanda_titulo" name="demanda[titulo]" placeholder="Ex: Agendamento de consulta">
            </div>
        </div>
        <div class="form-group">
            <label for="demanda_descricao">Descrição da Demanda:</label>
            <textarea id="demanda_descricao" name="demanda[descricao]" rows="3"></textarea>
        </div>

        <hr>


        <h2><i class="fas fa-info-circle"></i> Outras Informações</h2>
        <div class="form-row">
            <div class="form-group col-md-6">
                <label for="sexo">Sexo:</label>
                <select id="sexo" name="sexo">
                    <option value="">Selecione...</option>
                    <option value="Masculino">Masculino</option>
                    <option value="Feminino">Feminino</option>
                    <option value="Outro">Outro</option>
                </select>
            </div>
            <div class="form-group col-md-6">
                <label for="tipo">Tipo:</label>
                <select id="tipo" name="tipo" required>
                    <option value="Apoiador">Apoiador</option>
                    <option value="Liderança">Liderança</option>
                </select>
            </div>
        </div>

        <div class="form-group">
            <label for="observacao">Observação Geral:</label>
            <textarea id="observacao" name="observacao" rows="4"></textarea>
        </div>

        <div class="form-actions">
            <button type="submit" class="btn-primary">Salvar Eleitor</button>
            <a href="<?= BASE_URL ?>/eleitores" class="btn-secondary">Cancelar</a>
        </div>
    </form>
</div>

<style>
    .form-container { max-width: 800px; margin: auto; }
    .form-container h2 {
        font-size: 1.2em;
        color: #333;
        border-bottom: 2px solid #f0f0f0;
        padding-bottom: 5px;
        margin-top: 25px;
        margin-bottom: 20px;
    }
    .form-container h2 i {
        margin-right: 8px;
        color: #337ab7;
    }
    .form-row { display: flex; flex-wrap: wrap; margin-left: -10px; margin-right: -10px; }
    .form-group { padding: 0 10px; margin-bottom: 15px; flex-grow: 1; }
    .col-md-2 { flex-basis: 16.66%; }
    .col-md-4 { flex-basis: 33.33%; }
    .col-md-6 { flex-basis: 50%; }
    .col-md-8 { flex-basis: 66.66%; }
    .col-md-12 { flex-basis: 100%; }
    .form-group label { display: block; margin-bottom: 5px; font-weight: bold; }
    .form-group input, .form-group select, .form-group textarea {
        width: 100%;
        padding: 10px;
        border: 1px solid #ccc;
        border-radius: 4px;
        box-sizing: border-box;
    }
    .form-actions { text-align: right; margin-top: 20px; }
    .btn-primary, .btn-secondary {
        padding: 10px 20px;
        border: none;
        border-radius: 5px;
        color: white;
        text-decoration: none;
        cursor: pointer;
        font-weight: bold;
    }
    .btn-primary { background-color: #28a745; }
    .btn-secondary { background-color: #6c757d; }
</style>