<div class="documentos-container">
    <div class="page-header">
        <h1><i class="fas fa-folder-open"></i> Arquivo de Documentos e Multimídia</h1>
        <p>Gerencie documentos, fotos e vídeos publicitários do gabinete</p>
    </div>

    <?php // Mensagens de feedback ?>
    <?php if (isset($_SESSION['upload_success'])): ?>
        <div class="alert alert-success">
            <i class="fas fa-check-circle"></i> <?= $_SESSION['upload_success'] ?>
        </div>
        <?php unset($_SESSION['upload_success']); ?>
    <?php endif; ?>
    
    <?php if (isset($_SESSION['upload_error'])): ?>
        <div class="alert alert-danger">
            <i class="fas fa-exclamation-triangle"></i> <?= $_SESSION['upload_error'] ?>
        </div>
        <?php unset($_SESSION['upload_error']); ?>
    <?php endif; ?>

    <div class="main-grid">
        <!-- Seção de Upload -->
        <div class="upload-section">
            <div class="card">
                <div class="card-header">
                    <h2><i class="fas fa-cloud-upload-alt"></i> Novo Arquivo</h2>
                </div>
                <div class="card-body">
                    <form id="uploadForm" action="<?= BASE_URL ?>/documentos/upload" method="POST" enctype="multipart/form-data">
                        <div class="form-group">
                            <label for="titulo"><i class="fas fa-heading"></i> Título:</label>
                            <input type="text" id="titulo" name="titulo" required placeholder="Digite o título do arquivo">
                        </div>

                        <div class="form-group">
                            <label for="descricao"><i class="fas fa-align-left"></i> Descrição:</label>
                            <textarea id="descricao" name="descricao" rows="3" placeholder="Descrição opcional do arquivo"></textarea>
                        </div>

                        <div class="form-row">
                            <div class="form-group">
                                <label for="categoria"><i class="fas fa-tags"></i> Categoria:</label>
                                <select id="categoria" name="categoria" required>
                                    <option value="">Selecione uma categoria</option>
                                    <optgroup label="Documentos Oficiais">
                                        <option value="Ofício">Ofício</option>
                                        <option value="Requerimento">Requerimento</option>
                                        <option value="Projetos">Projetos</option>
                                        <option value="Prestação de Contas">Prestação de Contas</option>
                                    </optgroup>
                                    <optgroup label="Material Publicitário">
                                        <option value="Foto Publicitária">Foto Publicitária</option>
                                        <option value="Vídeo Publicitário">Vídeo Publicitário</option>
                                        <option value="Material de Campanha">Material de Campanha</option>
                                        <option value="Peça Gráfica">Peça Gráfica</option>
                                    </optgroup>
                                    <option value="Diversos">Diversos</option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label for="evento_campanha"><i class="fas fa-calendar-alt"></i> Evento/Campanha:</label>
                                <input type="text" id="evento_campanha" name="evento_campanha" placeholder="Nome do evento ou campanha">
                            </div>
                        </div>

                        <div class="form-group">
                            <label for="tags"><i class="fas fa-hashtag"></i> Tags:</label>
                            <input type="text" id="tags" name="tags" placeholder="Separadas por vírgula (ex: campanha, eleições, 2024)">
                        </div>

                        <div class="form-group">
                            <label for="arquivo"><i class="fas fa-file"></i> Selecionar Arquivo:</label>
                            <div class="file-input-wrapper">
                                <input type="file" id="arquivo" name="arquivo" required accept=".pdf,.doc,.docx,.txt,.odt,.jpg,.jpeg,.png,.gif,.webp,.svg,.mp4,.avi,.mov,.wmv,.flv,.webm">
                                <div class="file-info">
                                    <div class="file-types">
                                        <span class="file-type"><i class="fas fa-file-pdf"></i> Documentos</span>
                                        <span class="file-type"><i class="fas fa-image"></i> Imagens</span>
                                        <span class="file-type"><i class="fas fa-video"></i> Vídeos</span>
                                    </div>
                                    <div class="file-limits">
                                        <small>Documentos: até 10MB | Imagens: até 5MB | Vídeos: até 100MB</small>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-upload"></i> Enviar Arquivo
                        </button>
                    </form>
                </div>
            </div>
        </div>

        <!-- Seção de Filtros e Busca -->
        <div class="filters-section">
            <div class="card">
                <div class="card-header">
                    <h2><i class="fas fa-filter"></i> Filtros e Busca</h2>
                </div>
                <div class="card-body">
                    <form action="<?= BASE_URL ?>/documentos" method="GET" class="filters-form">
                        <div class="form-group">
                            <label for="busca"><i class="fas fa-search"></i> Buscar:</label>
                            <input type="text" id="busca" name="busca" value="<?= htmlspecialchars($_GET['busca'] ?? '') ?>" placeholder="Título, tags ou descrição">
                        </div>

                        <div class="form-row">
                            <div class="form-group">
                                <label for="filter_tipo"><i class="fas fa-layer-group"></i> Tipo:</label>
                                <select id="filter_tipo" name="tipo_midia">
                                    <option value="">Todos os tipos</option>
                                    <option value="documento" <?= ($_GET['tipo_midia'] ?? '') == 'documento' ? 'selected' : '' ?>>📄 Documentos</option>
                                    <option value="imagem" <?= ($_GET['tipo_midia'] ?? '') == 'imagem' ? 'selected' : '' ?>>🖼️ Imagens</option>
                                    <option value="video" <?= ($_GET['tipo_midia'] ?? '') == 'video' ? 'selected' : '' ?>>🎥 Vídeos</option>
                                </select>
                            </div>

                            <div class="form-group">
                                <label for="filter_categoria"><i class="fas fa-tags"></i> Categoria:</label>
                                <select id="filter_categoria" name="categoria">
                                    <option value="">Todas as categorias</option>
                                    <option value="Ofício" <?= ($_GET['categoria'] ?? '') == 'Ofício' ? 'selected' : '' ?>>Ofício</option>
                                    <option value="Requerimento" <?= ($_GET['categoria'] ?? '') == 'Requerimento' ? 'selected' : '' ?>>Requerimento</option>
                                    <option value="Projetos" <?= ($_GET['categoria'] ?? '') == 'Projetos' ? 'selected' : '' ?>>Projetos</option>
                                    <option value="Prestação de Contas" <?= ($_GET['categoria'] ?? '') == 'Prestação de Contas' ? 'selected' : '' ?>>Prestação de Contas</option>
                                    <option value="Foto Publicitária" <?= ($_GET['categoria'] ?? '') == 'Foto Publicitária' ? 'selected' : '' ?>>Foto Publicitária</option>
                                    <option value="Vídeo Publicitário" <?= ($_GET['categoria'] ?? '') == 'Vídeo Publicitário' ? 'selected' : '' ?>>Vídeo Publicitário</option>
                                    <option value="Material de Campanha" <?= ($_GET['categoria'] ?? '') == 'Material de Campanha' ? 'selected' : '' ?>>Material de Campanha</option>
                                    <option value="Peça Gráfica" <?= ($_GET['categoria'] ?? '') == 'Peça Gráfica' ? 'selected' : '' ?>>Peça Gráfica</option>
                                    <option value="Diversos" <?= ($_GET['categoria'] ?? '') == 'Diversos' ? 'selected' : '' ?>>Diversos</option>
                                </select>
                            </div>
                        </div>

                        <div class="form-actions">
                            <button type="submit" class="btn btn-secondary">
                                <i class="fas fa-search"></i> Filtrar
                            </button>
                            <a href="<?= BASE_URL ?>/documentos" class="btn btn-outline">
                                <i class="fas fa-times"></i> Limpar
                            </a>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Seção de Listagem de Documentos -->
    <div class="documents-section">
        <div class="card">
            <div class="card-header">
                <h2><i class="fas fa-list"></i> Documentos Cadastrados</h2>
                <span class="document-count"><?= count($documentos) ?> documento(s) encontrado(s)</span>
            </div>
            <div class="card-body">
                <?php if (empty($documentos)): ?>
                    <div class="empty-state">
                        <i class="fas fa-folder-open fa-3x"></i>
                        <h3>Nenhum documento encontrado</h3>
                        <p>Faça upload de um documento ou ajuste os filtros de busca.</p>
                    </div>
                <?php else: ?>
                    <div class="documents-grid">
                        <?php foreach ($documentos as $doc): ?>
                            <div class="document-card">
                                <div class="document-icon">
                                    <?php 
                                    $ext = strtolower(pathinfo($doc['nome_arquivo'], PATHINFO_EXTENSION));
                                    if (in_array($ext, ['jpg', 'jpeg', 'png', 'gif', 'webp'])): ?>
                                        <i class="fas fa-image"></i>
                                    <?php elseif (in_array($ext, ['mp4', 'avi', 'mov', 'wmv'])): ?>
                                        <i class="fas fa-video"></i>
                                    <?php elseif ($ext == 'pdf'): ?>
                                        <i class="fas fa-file-pdf"></i>
                                    <?php else: ?>
                                        <i class="fas fa-file-alt"></i>
                                    <?php endif; ?>
                                </div>
                                <div class="document-info">
                                    <h4><?= htmlspecialchars($doc['titulo']) ?></h4>
                                    <p class="document-meta">
                                        <span class="category"><?= htmlspecialchars($doc['categoria']) ?></span>
                                        <span class="date"><?= date('d/m/Y H:i', strtotime($doc['data_upload'])) ?></span>
                                    </p>
                                    <p class="document-user">Por: <?= htmlspecialchars($doc['nome_usuario']) ?></p>
                                    <p class="document-size"><?= number_format($doc['tamanho_arquivo'] / 1024, 1) ?> KB</p>
                                </div>
                                <div class="document-actions">
                                    <a href="<?= BASE_URL ?>/<?= $doc['caminho_arquivo'] ?>" target="_blank" class="btn btn-sm btn-primary">
                                        <i class="fas fa-eye"></i> Ver
                                    </a>
                                    <a href="<?= BASE_URL ?>/<?= $doc['caminho_arquivo'] ?>" download class="btn btn-sm btn-secondary">
                                        <i class="fas fa-download"></i> Baixar
                                    </a>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>

</div>

<script>
// Scripts básicos para o formulário
document.addEventListener('DOMContentLoaded', function() {
    // Funcionalidade básica do formulário já está implementada no CSS e HTML
    console.log('Sistema de documentos carregado');
});
</script>