<div class="content-box">
    <h1>Painel de Gestão de Documentos</h1>
    
    <?php // Mostra mensagens de sucesso ou erro do upload
    if (isset($_SESSION['upload_success'])): ?>
        <div class="alert alert-success"><?= $_SESSION['upload_success'] ?></div>
        <?php unset($_SESSION['upload_success']); ?>
    <?php endif; ?>
    <?php if (isset($_SESSION['upload_error'])): ?>
        <div class="alert alert-danger"><?= $_SESSION['upload_error'] ?></div>
        <?php unset($_SESSION['upload_error']); ?>
    <?php endif; ?>

    <div class="admin-grid">
        <div class="upload-form-container">
            <h2><i class="fas fa-upload"></i> Novo Documento</h2>
            <form action="<?= BASE_URL ?>/admin/upload" method="POST" enctype="multipart/form-data">
                <div class="form-group">
                    <label for="titulo">Título do Documento:</label>
                    <input type="text" id="titulo" name="titulo" required>
                </div>
                <div class="form-group">
                    <label for="categoria">Categoria:</label>
                    <select id="categoria" name="categoria" required>
                        <option value="Ofício">Ofício</option>
                        <option value="Requerimento">Requerimento</option>
                        <option value="Projetos">Projetos</option>
                        <option value="Prestação de Contas">Prestação de Contas</option>
                        <option value="Diversos">Diversos</option>
                    </select>
                </div>
                <div class="form-group">
                    <label for="arquivo">Selecione o arquivo (PDF, DOCX, PNG, JPG):</label>
                    <input type="file" id="arquivo" name="arquivo" required>
                </div>
                <button type="submit" class="btn-upload">Enviar Documento</button>
            </form>
        </div>

        <div class="document-list-container">
            <h2><i class="fas fa-search"></i> Buscar e Listar Documentos</h2>
            <form action="<?= BASE_URL ?>/admin/dashboard" method="GET" class="search-form">
                <select name="categoria" onchange="this.form.submit()">
                    <option value="">Todas as Categorias</option>
                    <option value="Ofício" <?= ($categoria_filtro ?? '') == 'Ofício' ? 'selected' : '' ?>>Ofício</option>
                    <option value="Requerimento" <?= ($categoria_filtro ?? '') == 'Requerimento' ? 'selected' : '' ?>>Requerimento</option>
                    <option value="Projetos" <?= ($categoria_filtro ?? '') == 'Projetos' ? 'selected' : '' ?>>Projetos</option>
                    <option value="Prestação de Contas" <?= ($categoria_filtro ?? '') == 'Prestação de Contas' ? 'selected' : '' ?>>Prestação de Contas</option>
                    <option value="Diversos" <?= ($categoria_filtro ?? '') == 'Diversos' ? 'selected' : '' ?>>Diversos</option>
                </select>
                <a href="<?= BASE_URL ?>/admin/dashboard">Limpar Filtro</a>
            </form>

            <table>
                <thead>
                    <tr>
                        <th>Título</th>
                        <th>Categoria</th>
                        <th>Enviado por</th>
                        <th>Data</th>
                        <th>Ações</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (isset($documentos) && count($documentos) > 0): ?>
                        <?php foreach($documentos as $doc): ?>
                        <tr>
                            <td><?= htmlspecialchars($doc['titulo']) ?></td>
                            <td><?= htmlspecialchars($doc['categoria']) ?></td>
                            <td><?= htmlspecialchars($doc['nome_usuario']) ?></td>
                            <td><?= date('d/m/Y H:i', strtotime($doc['data_upload'])) ?></td>
                            <td class="actions">
                                <a href="<?= BASE_URL ?>/<?= htmlspecialchars($doc['caminho_arquivo']) ?>" target="_blank" title="Baixar/Ver"><i class="fas fa-download"></i></a>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr><td colspan="5">Nenhum documento encontrado.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>
<style>
/* Estilos para os alertas */
.alert { padding: 15px; margin-bottom: 20px; border: 1px solid transparent; border-radius: 4px; }
.alert-success { color: #155724; background-color: #d4edda; border-color: #c3e6cb; }
.alert-danger { color: #721c24; background-color: #f8d7da; border-color: #f5c6cb; }
</style>
