<?php
require_once __DIR__ . '/../config/log.php'; 
require_once __DIR__ . '/../models/Usuario.php';
require_once __DIR__ . '/../config/config.php';

class UsuarioController {

    public function login() {
        Logger::log("Tentativa de acesso à página de login.");
        
        // Se já está logado, redireciona para a agenda
        if (isset($_SESSION['logado']) && $_SESSION['logado'] === true) {
            Logger::log("Usuário já logado. Redirecionando para agenda.");
            header('Location: ' . BASE_URL . '/agendas'); 
            exit();
        }
        
        Logger::log("Exibindo formulário de login.");
        
        // Define o título da página
        $pageTitle = "Login - Sistema de Gabinete";
        
        // Carrega a view de login
        require_once __DIR__ . '/../views/usuarios/login.php';
    }

    public function processarLogin() {
        Logger::log("Tentativa de processar login.");
        
        if ($_SERVER["REQUEST_METHOD"] == "POST" && !empty($_POST['email']) && !empty($_POST['senha'])) {
            
            $email = trim($_POST['email']);
            $senha = $_POST['senha'];

            Logger::log("Dados de POST recebidos. E-mail: " . $email);
            
            $usuarioModel = new Usuario();
            $usuarioLogado = $usuarioModel->verificarLogin($email, $senha);
            
            if ($usuarioLogado) {
                Logger::log("Login bem-sucedido para o usuário: " . $email);
                
                // Regenera o ID da sessão por segurança
                session_regenerate_id(true);
                
                // Define as variáveis de sessão
                $_SESSION['logado'] = true;
                $_SESSION['usuario_id'] = $usuarioLogado['id'];
                $_SESSION['usuario_nome'] = $usuarioLogado['nome'];
                $_SESSION['usuario_email'] = $usuarioLogado['email'];
                $_SESSION['usuario_nivel_acesso'] = $usuarioLogado['nivel_acesso'];
                
                // Redireciona para a agenda (página inicial do sistema)
                header("Location: " . BASE_URL . "/agendas");
                exit();
            } else {
                Logger::log("Login falhou para o usuário: " . $email);
                $_SESSION['erro_login'] = "E-mail ou senha inválidos.";
            }
        } else {
            Logger::log("Dados de login incompletos.");
            $_SESSION['erro_login'] = "Por favor, preencha todos os campos.";
        }
        
        // Se chegou até aqui, houve erro - volta para o login
        header("Location: " . BASE_URL . "/usuario/login");
        exit();
    }

    public function logout() {
        Logger::log("Logout iniciado para usuário: " . ($_SESSION['usuario_email'] ?? 'desconhecido'));
        
        // Destrói todas as variáveis de sessão
        session_unset();
        session_destroy();
        
        Logger::log("Sessão destruída. Redirecionando para login.");
        header("Location: " . BASE_URL . "/usuario/login");
        exit();
    }
}
?>
