<?php
// Carrega os models e helpers necessários.
require_once __DIR__ . '/../models/Relatorio.php';
// ADICIONADO: A linha que faltava para incluir o helper de autenticação.
require_once __DIR__ . '/../helpers/AuthHelper.php';

class RelatoriosController {

    public function index() {
        // Esta linha agora funcionará porque o AuthHelper foi incluído.
        AuthHelper::check();

        $relatorioModel = new Relatorio();

        // Coleta todos os dados do model
        $dados = [
            'totalEleitores' => $relatorioModel->getTotalEleitores(),
            'porSexo' => $relatorioModel->getContagemPorSexo(),
            'porBairro' => $relatorioModel->getContagemPorBairro(),
            'porTipo' => $relatorioModel->getContagemPorTipo(),
            'porDemanda' => $relatorioModel->getContagemPorDemanda(),
            'eleitoresRecentes' => $relatorioModel->getEleitoresRecentes()
        ];
        
        $pageTitle = "Relatórios e Estatísticas";
        
        require_once __DIR__ . '/../views/partials/header.php';
        require_once __DIR__ . '/../views/relatorios/index.php';
        require_once __DIR__ . '/../views/partials/footer.php';
    }
}
