<?php

class Logger {
    private static $logFile = __DIR__ . '/../logs/app.log';

    public static function log($message) {
        // Garante que o diretório 'logs' existe. A flag `true` cria diretórios aninhados, se necessário.
        $logDir = dirname(self::$logFile);
        if (!is_dir($logDir)) {
            mkdir($logDir, 0777, true);
        }
        
        // Formata a mensagem com data e hora
        $formattedMessage = "[" . date("Y-m-d H:i:s") . "] " . $message . PHP_EOL;
        
        // Escreve a mensagem no arquivo. FILE_APPEND garante que o conteúdo seja adicionado ao final.
        file_put_contents(self::$logFile, $formattedMessage, FILE_APPEND);
    }
}

?>