<?php
/**
 * Roteador Principal (Front Controller) - VERSÃO CORRIGIDA
 * Este ficheiro é o único ponto de entrada para a aplicação.
 */

// Inicia a sessão para todas as páginas
session_start();

// Carrega as configurações essenciais
require_once 'src/config/config.php';

// --- Lógica de Roteamento Simplificada ---

// 1. Analisa a URL solicitada
$url = $_GET['url'] ?? '';
$url = rtrim($url, '/');
$url = filter_var($url, FILTER_SANITIZE_URL);
$urlParts = explode('/', $url);

// 2. Define controller e método padrão
$controllerName = 'UsuarioController';
$methodName = 'login';
$params = [];

// 3. Verifica se o utilizador está logado
if (isset($_SESSION['logado']) && $_SESSION['logado'] === true) {
    
    // --- USUÁRIO LOGADO ---
    
    if (empty($urlParts[0])) {
        // URL vazia - vai para a agenda
        $controllerName = 'AgendasController';
        $methodName = 'index';
    } else {
        // Define controller baseado na URL
        $controllerName = ucfirst($urlParts[0]) . 'Controller';
        $methodName = $urlParts[1] ?? 'index';
        $params = count($urlParts) > 2 ? array_slice($urlParts, 2) : [];
        
        // Tratamento especial para rotas do WhatsApp
        if ($urlParts[0] === 'configuracoes' && isset($urlParts[1])) {
            if ($urlParts[1] === 'whatsapp') {
                $methodName = 'whatsapp';
            } elseif ($urlParts[1] === 'salvar-whatsapp') {
                $methodName = 'salvarWhatsApp';
            } elseif ($urlParts[1] === 'testar-whatsapp') {
                $methodName = 'testarWhatsApp';
            }
        }
        
        // Tratamento especial para rotas do Material Publicitário
        if ($urlParts[0] === 'material-publicitario') {
            $controllerName = 'MaterialPublicitarioController';
            $methodName = $urlParts[1] ?? 'index';
            $params = count($urlParts) > 2 ? array_slice($urlParts, 2) : [];
        }
        
        // Tratamento especial para rotas do RH
        if ($urlParts[0] === 'rh') {
            $controllerName = 'RhController';
            $methodName = $urlParts[1] ?? 'index';
            $params = count($urlParts) > 2 ? array_slice($urlParts, 2) : [];
        }
        
        // Tratamento especial para rotas dos Colaboradores
        if ($urlParts[0] === 'employees') {
            $controllerName = 'EmployeesController';
            $methodName = $urlParts[1] ?? 'index';
            $params = count($urlParts) > 2 ? array_slice($urlParts, 2) : [];
        }
        
        // Tratamento especial para rotas do Controle de Ponto
        if ($urlParts[0] === 'time-records') {
            $controllerName = 'TimeRecordsController';
            $methodName = $urlParts[1] ?? 'index';
            $params = count($urlParts) > 2 ? array_slice($urlParts, 2) : [];
        }
        
        // Tratamento especial para rotas da Folha de Pagamento
        if ($urlParts[0] === 'payrolls') {
            $controllerName = 'PayrollsController';
            $methodName = $urlParts[1] ?? 'index';
            $params = count($urlParts) > 2 ? array_slice($urlParts, 2) : [];
        }
        
        // Rota especial para teste completo
        if ($urlParts[0] === 'test' && $urlParts[1] === 'complete') {
            require_once 'src/views/test_complete.php';
            exit;
        }
    }

} else {

    // --- USUÁRIO NÃO LOGADO ---
    
    // Rota especial para teste completo (sem necessidade de login)
    if ($urlParts[0] === 'test' && $urlParts[1] === 'complete') {
        require_once 'src/views/test_complete.php';
        exit;
    }
    
    // Rota para reset de senha (sem necessidade de login)
    if ($urlParts[0] === 'reset' && $urlParts[1] === 'password') {
        require_once 'reset_password.php';
        exit;
    }
    
    // Rota para teste de banco (sem necessidade de login)
    if ($urlParts[0] === 'test' && $urlParts[1] === 'db') {
        require_once 'test_db.php';
        exit;
    }
    
    // Rota especial para debug de login
    if ($urlParts[0] === 'debug' && $urlParts[1] === 'login') {
        require_once 'debug_login.php';
        exit;
    }
    
    // Só permite acesso às rotas de login
    if (!empty($urlParts[0]) && $urlParts[0] === 'usuario') {
        $controllerName = 'UsuarioController';
        $methodName = $urlParts[1] ?? 'login';
        
        // Só permite 'login' e 'processarLogin'
        if (!in_array($methodName, ['login', 'processarLogin'])) {
            $methodName = 'login';
        }
    }
    // Para qualquer outra rota, força o login
}

// 4. Carrega e executa o Controller
$controllerFile = 'src/controllers/' . $controllerName . '.php';

if (file_exists($controllerFile)) {
    require_once $controllerFile;

    if (class_exists($controllerName)) {
        $controller = new $controllerName();

        if (method_exists($controller, $methodName)) {
            // Chama o método com os parâmetros
            call_user_func_array([$controller, $methodName], $params);
        } else {
            // Método não encontrado - vai para login se não logado, senão erro 404
            if (!isset($_SESSION['logado']) || $_SESSION['logado'] !== true) {
                $controller = new UsuarioController();
                $controller->login();
            } else {
                die("Erro 404: Método '{$methodName}' não encontrado.");
            }
        }
    } else {
        die("Erro 404: Classe '{$controllerName}' não encontrada.");
    }
} else {
    // Controller não encontrado - vai para login se não logado
    if (!isset($_SESSION['logado']) || $_SESSION['logado'] !== true) {
        require_once 'src/controllers/UsuarioController.php';
        $controller = new UsuarioController();
        $controller->login();
    } else {
        die("Erro 404: Controller '{$controllerName}' não encontrado.");
    }
}
