<?php
/**
 * contas/db.php — Conexão compatível com $mysqli e $conexao
 * Banco: DB_CONTAS (MAMP: porta 8889, user root, pass root)
 */
date_default_timezone_set('America/Belem');

// Permite usar constantes caso existam (ex.: definidas no sistema principal)
$DB_HOST = defined('DB_HOST') ? DB_HOST : (getenv('DB_HOST') ?: 'localhost');
$DB_PORT = defined('DB_PORT') ? DB_PORT : (getenv('DB_PORT') !== false ? intval(getenv('DB_PORT')) : 8889);
$DB_USER = defined('DB_USER') ? DB_USER : (getenv('DB_USER') ?: 'root');
$DB_PASS = defined('DB_PASS') ? DB_PASS : (getenv('DB_PASS') ?: 'root');
$DB_NAME = defined('DB_NAME_CONTAS') ? DB_NAME_CONTAS : (getenv('DB_NAME_CONTAS') ?: 'DB_CONTAS');

mysqli_report(MYSQLI_REPORT_ERROR | MYSQLI_REPORT_STRICT);

try {
    $mysqli = new mysqli($DB_HOST, $DB_USER, $DB_PASS, $DB_NAME, $DB_PORT);
    $mysqli->set_charset('utf8mb4');
} catch (mysqli_sql_exception $e) {
    http_response_code(500);
    die("Falha ao conectar ao banco DB_CONTAS
        <br>Host: {$DB_HOST}:{$DB_PORT}
        <br>Usuário: {$DB_USER}
        <br>Base: {$DB_NAME}
        <br><br>Detalhe: " . htmlspecialchars($e->getMessage(), ENT_QUOTES, 'UTF-8'));
}

// Alias de compatibilidade: muitos scripts usam $conexao
if (!isset($conexao) || !$conexao) {
    $conexao = $mysqli;
}

/**
 * Helper opcional para obter a conexão atual
 */
function db_conn() {
    global $conexao, $mysqli;
    return $conexao ?: ($mysqli ?? null);
}
